// Postfix calculator

#import <stdio.h>
#import <Foundation/Foundation.h>

//------- @interface section -------

@protocol Printable
     -(void) printMe; // I can leave out @required, since it is the default
     @optional -(NSString*) printMeToString;
@end

@class StackOfInteger; // forward declaration

@interface PostfixCalculator:NSObject
{
    @public NSString* expression;
    
    @protected StackOfInteger* calculatorStack;

}

- (id)    initWithExpression: (NSString *) postFixExpression;
+ (PostfixCalculator*) CreateWithExpression: (NSString *) postFixExpression;
- (int)    calculate;
- (NSString*) getExpression;
+ (void) printClassDescription;

@end

@interface StackOfInteger:NSObject <Printable>
{
    @protected NSMutableArray* elements; /// protected is the default property
    @private int last;
}
    @property (nonatomic, readonly) int stackPointer;
    - (BOOL) isEmpty;
    - (void) push: (int) n;
    - (void) push2: (int) intValue1 another:(int) intValue2;
    - (int) pop;


@end

//------- @implementation section -------
@implementation StackOfInteger;
@synthesize stackPointer=last;

- (id) init{
    self = [super init];
    self->last = -1;
    elements = [[NSMutableArray alloc] init];
    return self;
}

- (BOOL) isEmpty{
    return (self->last == -1);
}

- (void) push: (int) intValue{
    NSLog(@"Entering method >%@<", NSStringFromSelector(_cmd));
    NSNumber* intObject = [NSNumber numberWithInt:intValue];
    [elements addObject:intObject];
    self->last++;
    NSLog(@"Leaving method >%@<", NSStringFromSelector(_cmd));
}

- (void) push2: (int) intValue1 another:(int) intValue2 {
    NSNumber* intObject = [NSNumber numberWithInt:intValue1];
    [elements addObject:intObject];
    intObject = [NSNumber numberWithInt:intValue2];
    [elements addObject:intObject];
    self->last+=2;
}

- (int) pop{
    NSNumber* element = (NSNumber *) [self->elements objectAtIndex:(self->last)];
    self->last--;
    int intValue = [element intValue];
    [self->elements removeLastObject];
    return intValue;
}

/////////// Methods to implement the Printable protocol ////////////

- (void) printMe{
    int k, stackCount = [elements count];
    NSLog (@"Stack->Last >%d< \n", self->last);
    for(k=0; k<stackCount; k++) {
        NSLog (@"Element at [%d] = >%@<\n", k, [elements objectAtIndex:k]);
    }
}
/*
- (NSString *) printMeToString{
    NSString* retString;
    
    return @"printMeToString will be implemented later"; 
}
*/ 

@end

#define ADD "+"
#define SUB "="
#define DIV "/"
#define MUL "*"
#define SPACE " "

@implementation PostfixCalculator;

- (id) initWithExpression: (NSString *) postFixExpression{
    calculatorStack = [[StackOfInteger alloc] init];
    expression = postFixExpression;
    return self;
}

+ (PostfixCalculator*) CreateWithExpression: (NSString *) postFixExpression{
    PostfixCalculator* newCalculator = [[PostfixCalculator alloc] init];
    newCalculator->calculatorStack = [[StackOfInteger alloc] init];
    newCalculator->expression = postFixExpression;
    return newCalculator;
}

- (NSString*) getExpression{
    return expression;
}

- (int) calculate
{
    BOOL done=NO;
    NSArray* expressionComponents = [expression componentsSeparatedByString:@SPACE];
    NSLog(@"Expression Components >%@<", expressionComponents);
    int k=0;
    while (done == NO){
        NSString* expressionElement = [expressionComponents objectAtIndex:k];
        NSLog(@"Expression Element >%@<", expressionElement);
        if([expressionElement isEqualToString:@ADD]){
            int intValue1 = [calculatorStack pop];
            int intValue2 = [calculatorStack pop];
            int result = intValue1 + intValue2;
            printf("Calculating >%d %d %d<\n", intValue1, intValue2, result);
            [calculatorStack push:result];
            printf("Pushing result value >%d<\n", result);
        } else if([expressionElement isEqualToString:@SUB]){
            int intValue1 = [calculatorStack pop];
            int intValue2 = [calculatorStack pop];
            int result = intValue1 - intValue2;
            printf("Calculating >%d %d %d<\n", intValue1, intValue2, result);
            [calculatorStack push:result];
            printf("Pushing result value >%d<\n", result);
        } else if([expressionElement isEqualToString:@DIV]){
            int intValue1 = [calculatorStack pop];
            int intValue2 = [calculatorStack pop];
            int result = intValue1 / intValue2;
            printf("Calculating >%d %d %d<\n", intValue1, intValue2, result);
            [calculatorStack push:result];
            printf("Pushing result value >%d<\n", result);
        } else if([expressionElement isEqualToString:@MUL]){
            int intValue1 = [calculatorStack pop];
            int intValue2 = [calculatorStack pop];
            int result = intValue1 * intValue2;
            printf("Calculating >%d %d %d<\n", intValue1, intValue2, result);
            [calculatorStack push:result];
            printf("Pushing result value >%d<\n", result);
        } else {
            int intValue = [expressionElement intValue];
            [calculatorStack push:intValue];
            printf("Pushing >%d<\n", intValue);
        }
        printf("in calculate loop\n");
        k++;
        if ( k == [expressionComponents count]) done = YES;
    }
    printf("outside calculate loop\n");
    int finalResult = [calculatorStack pop];
    return finalResult;
}

+ (void) printClassDescription{
    printf("In printClassDescription\n");
}

@end

@interface NSString (ReversibleString)
    - (NSString *)reverse;
@end

@implementation NSString (ReversibleString)

    - (NSString *)reverse {
        NSMutableString *reversedString = [[NSMutableString alloc] init];
        int stringLength = self.length;
        for (int i=stringLength-1; i >=0; i--){
            NSString *oneCharString = [self substringWithRange:NSMakeRange(i, 1)];
	    [reversedString appendString:oneCharString];
        }
        return reversedString;
    }

@end

int main (int argc, char *argv[])
{ 
    //////////////////// Working with Stacks of integers ///////////////////////////////
    
    printf("Working with Stacks of integers\n");
    // Creating a StackOfInt using the alloc and an init method
    StackOfInteger *myStack = [[StackOfInteger alloc] init];
    [myStack push2:25 another:255];    
    int intValue1 = [myStack pop]; 
    int intValue2 = myStack.pop; // Same as int intValue2 = [myStack pop];
    printf("First value is >%d< Second value is >%d<\n", intValue1,intValue2);

    printf("Done working with Stacks of integers\n");

    ///////////////////Working with Postfix calculator /////////////////////////
    
    printf("Working with Postfix calculators\n");
    
    // Creating a Postfix Calculator using the alloc and a custom init method
    PostfixCalculator *myCalculatorWithInit = 
        [[PostfixCalculator alloc] initWithExpression:@"44 55 *"];
    
    // Creating a Postfix Calculator using a class method, also known as a Factory method
    PostfixCalculator *myCalculator = [PostfixCalculator CreateWithExpression:@"44 55 *"];
    
    // Using a PostfixCalculator
    NSString * myExpression = [myCalculator getExpression];
    NSLog(@"Expression >%@<", myExpression);
    myExpression = myCalculator->expression;
    NSLog(@"Expression accessed directly>%@<", myExpression);
    int result = [myCalculator calculate];
    printf("result >%d<\n", result);
    NSLog (@"%d", result);
    
    printf("Done working with Postfix calculator\n");
    
    ////////////////// Creating objects through compiler directives /////////////
    
    NSString* aStringObject = @"This is a C String";
    NSLog(@"Printing aStringObject>%@<", aStringObject);
    
    /////////////////////////////// Using properties ///////////////////////////
    [myStack push2:251 another:2555];
    printf("Count of elements %d\n", [myStack stackPointer]);
    printf("Count of elements using dot notation %d\n", myStack.stackPointer);
    
   //////////////////////////////// Using categories ///////////////////////////////// 
    NSLog(@"Printing reversed string>%@<", [aStringObject reverse]);
   
   //////////////////////////////// Using protocols //////////////////////////////////
   
   printf("Testing conformance to protocols\n");
   if ([myStack conformsToProtocol:@protocol(Printable)]) { 
       printf("Using protocol methods\n");
       [myStack printMe];
      // NSLog(@"String representation of the stack >%@<\n", [myStack printMeToString]);
   } else {
       NSLog(@"Object does not conform to protocol %@\n", @protocol(Printable));  
   }   
   

   id someObject = [[PostfixCalculator alloc] initWithExpression:@"44 55 *"];
   if (![someObject conformsToProtocol:@protocol(Printable)]) { 
       NSLog(@"Object does not conform to protocol");  
   } 
    
    ///////////////// Introspection ///////////////

    printf("Getting the class and super class of an object\n");
    StackOfInteger *aStack = [[StackOfInteger alloc] init];    
    NSLog(@"Class is %@, and super is %@.", [aStack class], [aStack superclass]);
    
    printf("Calling a method of a class object using @selector\n");
    Class postfixCalculatorClass = [someObject class];
    [postfixCalculatorClass performSelector:@selector(printClassDescription)];
    
    printf("Calling a method of a class object given a string\n");
    SEL printClassDescriptionSEL = NSSelectorFromString(@"printClassDescription");
    [postfixCalculatorClass performSelector:printClassDescriptionSEL];
    
     /////////////////////////////// Using exceptions /////////////////////////
    
    @try {
        printf("I know this will fail\n");
        NSDictionary* emptyDictionary = [[NSDictionary alloc] init];
        NSException* anException = 
            [NSException exceptionWithName:@"MyException" reason:@"Just for grins" userInfo:emptyDictionary];
        @throw anException;
    } 
    @catch (NSException *exception) {
        NSLog(@"Exception caught with reason >%@<\n", exception);
    }
    
    printf("Returning from main program\n");
        
    return 0;
}